<?php
/* --------------------------------------------------------------
 AdminBootstrapper.php 2020-05-07
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Admin\Application\Kernel;

use Gambio\Admin\Application\Kernel\Bootstrapper\AdminErrorHandlerRegistration;
use Gambio\Admin\Application\Kernel\Bootstrapper\AdminRouteRegistration;
use Gambio\Admin\Application\Kernel\Bootstrapper\AdminServiceProviderRegistration;
use Gambio\Admin\Application\Kernel\Bootstrapper\LoadAdminShopConfiguration;
use Gambio\Admin\Application\Kernel\Bootstrapper\MiddlewareRegistration;
use Gambio\Core\Application\Application;
use Gambio\Core\Application\Kernel\AbstractBootstrapper;
use Gambio\Core\Application\Kernel\Bootstrapper;
use Gambio\Core\Application\Kernel\Bootstrapper\CommandDispatcherRegistration;
use Gambio\Core\Application\Kernel\Bootstrapper\CoreServiceProviderRegistration;
use Gambio\Core\Application\Kernel\Bootstrapper\EventDispatcherRegistration;
use Gambio\Core\Application\Kernel\Bootstrapper\LoadServerInformation;
use Gambio\Core\Application\Kernel\Bootstrapper\LoadUserPreferencesFromSession;
use Gambio\Core\Application\Kernel\Bootstrapper\PluginRegistration;
use Gambio\Core\Application\Kernel\Bootstrapper\RoutingMiddlewareRegistration;
use Gambio\Core\Application\Kernel\Bootstrapper\SetSessionParameters;
use Gambio\Core\Application\Kernel\Bootstrapper\SlimAppRegistration;
use Gambio\Core\Application\Kernel\Bootstrapper\StartSession;

/**
 * Class AdminBootstrapper
 * @package Gambio\Admin\Application\Kernel
 */
class AdminBootstrapper extends AbstractBootstrapper
{
    private const SUB_BOOTSTRAPPER = [
        0 => LoadAdminShopConfiguration::class,
        1 => SetSessionParameters::class,
        2 => StartSession::class,
        3 => LoadServerInformation::class,
        
        100 => EventDispatcherRegistration::class,
        200 => CommandDispatcherRegistration::class,
        
        300 => CoreServiceProviderRegistration::class,
        400 => AdminServiceProviderRegistration::class,
        500 => LoadUserPreferencesFromSession::class,
        
        600 => SlimAppRegistration::class,
        700 => RoutingMiddlewareRegistration::class,
        800 => AdminErrorHandlerRegistration::class,
        
        900 => MiddlewareRegistration::class,
        
        1000 => AdminRouteRegistration::class,
        
        1100 => PluginRegistration::class,
    ];
    
    
    /**
     * @inheritDoc
     */
    public function boot(Application $application): void
    {
        foreach (self::SUB_BOOTSTRAPPER as $bootstrapper) {
            /** @var Bootstrapper $instance */
            $instance = new $bootstrapper;
            $instance->boot($application);
        }
    }
}